/**
 * Clear Demo Data Script
 * Run this once to clean up demo data from localStorage
 */

(function() {
  console.log('🧹 Cleaning up demo data...');
  
  // Remove WhatsApp Cloud demo data
  const removed = [];
  
  if (localStorage.getItem('whatsapp_cloud_state')) {
    localStorage.removeItem('whatsapp_cloud_state');
    removed.push('whatsapp_cloud_state');
  }
  
  if (removed.length > 0) {
    console.log('✅ Removed demo data:', removed.join(', '));
    console.log('🔄 Please reload the page to load real data from backend');
  } else {
    console.log('✨ No demo data found. System is clean!');
  }
})();
